import os, sys
import argparse
import yaml
from configUtils import *

SIP_GUEST_USER = "sip_guest_user.dat"
SIP_SUBSCRIBER_FLOWS = "API Subscriber Flows"
SIP_SERVER_FLOWS = "API Server Flows"
REVERSE_PROXY_RELAY = "API Reverse Proxy Relays"

def sip_subscriber_flow():
    try:
        default_data = {"uriGroupId": 1, "userAgentId": 1, "sourceSubnet": "*", "viaHost": "*","contactHost": "*", "tlsClientProfileId": 0,"sigmaProfileId": 0,"presenceServerAddress": '',"secMediaInterfaceId": 0,"routingProfileId": 1}
        config_data = APIUtilities.file_utils(SIP_SUBSCRIBER_FLOWS)
        return APIUtilities.return_result(config_data, APIDefs.SIP_SUBSCRIBER_FLOWS.value, "flowId", default_data)
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e
        
def sip_server_flow():
    try:
        default_data = {}
        config_data = APIUtilities.file_utils(SIP_SERVER_FLOWS)
        return APIUtilities.check_id(APIUtilities.return_result(config_data, APIDefs.SIP_SERVER_FLOWS.value, "priority", default_data),"SIP_SERVER_FLOWS")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e
    except Exception as e:
        if(str(e) == "DATA_NOT_FOUND"):
            print("Server flow configuration is Optional and Data for it not found hence moving forward")
            return ""
        else:
            raise e
        
def reverse_proxy_relays():
    try:
        print("In reverse proxy relay...")
        config_data = APIUtilities.file_utils(REVERSE_PROXY_RELAY)
        return APIUtilities.check_id(APIUtilities.return_result(config_data, APIDefs.REVERSE_PROXY_RELAYS.value, "id"),"REVERSE_PROXY_RELAYS")
    except Exception as e:
        if(str(e) == "DATA_NOT_FOUND"):
            print("Reverse Proxy Relay configuration is Optional and Data for it not found hence moving forward")
            return ""
        raise e

def post_all():
    print("entered POST all")
    APIUtilities.getToken(APIDefs.API_TOKEN.value)
    APIUtilities.create_map(APIDefs.SIGNALING_INTERFACES.value, APIUtilities.get_request(APIDefs.SIGNALING_INTERFACES.value))
    APIUtilities.create_map(APIDefs.MEDIA_INTERFACES.value, APIUtilities.get_request(APIDefs.MEDIA_INTERFACES.value))
    APIUtilities.create_map(APIDefs.END_POINT_POLICY.value, APIUtilities.get_request(APIDefs.END_POINT_POLICY.value))
    APIUtilities.create_map(APIDefs.SIP_ROUTING_PROFILES.value, APIUtilities.get_request(APIDefs.SIP_ROUTING_PROFILES.value))
    APIUtilities.create_map(APIDefs.SIP_SERVER_PROFILES.value, APIUtilities.get_request(APIDefs.SIP_SERVER_PROFILES.value))
    APIUtilities.create_map(APIDefs.NETWORK_MANAGEMENT.value, APIUtilities.get_request(APIDefs.NETWORK_MANAGEMENT.value))
    APIUtilities.create_map(APIDefs.TLS_CLIENT_PROFILES.value, APIUtilities.get_request(APIDefs.TLS_CLIENT_PROFILES.value))
    APIUtilities.create_map(APIDefs.TLS_SERVER_PROFILES.value, APIUtilities.get_request(APIDefs.TLS_SERVER_PROFILES.value))
    
    APIUtilities.check_id(sip_subscriber_flow(), "SIP_SUBSCRIBER_FLOWS")
    print("---------------------------SIP SUBSCRIBER FLOWS ADDED---------------------------------")
    
    if(sip_server_flow() != ""):
        print("---------------------SIP SERVER FLOWS ADDED--------------------------")
    
    if(reverse_proxy_relays() != ""):
        print("---------------------REVERSE_PROXY_RELAY ADDED--------------------------")
    
    

def delete_resource(apiname, id):
    APIUtilities.delete_request(apiname, id)

if __name__ == '__main__':
    try:
        obj = APIUtilities(SIP_GUEST_USER)
        parser = argparse.ArgumentParser()

        parser.add_argument("HTTPMETHOD", choices={"POST", "DELETE"}, type=str)
        parser.add_argument("--apiname", type=str, choices=list(APIDefs.__members__),
                            help="Delete a configuration for HTTP call flow for given API, only used with DELETE")
        parser.add_argument("--id", type=int, help="The ID to be deleted, required only for DELETE")

        args = (parser.parse_args())

        if args.HTTPMETHOD == "POST":
            post_all()
        if args.HTTPMETHOD == "DELETE":
            if args.apiname is None or args.id is None:
                print("--apiname and --id required for DELETE")
            delete_resource(args.apiname, args.id)

    except Exception as e:
        exc_type, exc_obj, exc_tb = sys.exc_info()
        fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
        print("Error in main %s line_no %s" % (e,exc_tb.tb_lineno) )
        APIUtilities.bulk_delete()